#include <afxwin.h>
#include "ccolor.h"

BEGIN_MESSAGE_MAP(CColorBar, CStatic)
	ON_WM_PAINT()
END_MESSAGE_MAP()


void CColorBar::SetProperties(CRect	rect, BYTE r,BYTE g,BYTE b)
{
	bActive = TRUE;
	Rect.left = 0;
	Rect.top = 0;
	Rect.right = rect.right - rect.left;
	Rect.bottom = rect.bottom - rect.top;
	SetColor(r,g,b);
}


afx_msg void CColorBar::OnPaint()
{
	CStatic::OnPaint();
	Repaint();
}

void CColorBar::Repaint()
{
	if (!bActive) return;

	CDC* pdc = GetDC();
	if (pdc)
		pdc->FillSolidRect(&Rect, RGB(colorRed, colorGreen, colorBlue));
	ReleaseDC(pdc);
}

void CColorBar::SetColor(BYTE r,BYTE g,BYTE b)
{
	colorRed	= r;
	colorGreen= g;
	colorBlue	= b;
	Repaint();
}

void CColorBar::Deactivate()
{
	bActive = FALSE;
	ShowWindow(SW_HIDE);
}

void CColorBar::Activate()
{
	ShowWindow(SW_SHOW);
	bActive = TRUE;
	Repaint();
}

